var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"MAYAUL\">\n      <meta name=\"release\" content=\"2016\">\n      <meta name=\"book\" content=\"Tutorial\">\n      <meta name=\"created\" content=\"2015-10-30\">\n      <meta name=\"topicid\" content=\"GUID-C09DA9C0-A36B-4F6B-9CBD-61456E54B589\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <title>Lesson 4: Simulating the low resolution shirt</title><script language=\"javascript\">var index = \'index.html\';</script></head>\n   <body height=\"100%\">\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-C09DA9C0-A36B-4F6B-9CBD-61456E54B589\"></a><div class=\"head\">\n            <h1>Lesson 4: Simulating the low resolution shirt</h1>\n         </div>\n         <p><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7CC3\"></a>In this lesson, you simulate the character’s shirt using the workflow described in\n            Lesson 3. Although there are some variations in attributes and values, the principles\n            are the same. \n            	 \n         </p>\n         <p><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7CC2\"></a>In this lesson you will: \n            	 \n         </p><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7CC1\"></a><ul>\n            <li>Convert the Shirt_LowRes object to nCloth. \n               		\n            </li>\n            <li>Create a wrap deformer to influence the behavior of the high resolution mesh (Shirt_HighRes).\n               \n               		\n            </li>\n            <li>Apply the nCloth \n               		  <span class=\"MenuCascade\" id=\"GUID-75F776D3-91B2-4CCE-8A3E-EA61C84078A7\">tshirt \n                  		  </span>preset to the nCloth shirt. \n               		\n            </li>\n            <li>Edit the nCloth shirt \n               		  <span class=\"MenuCascade\" id=\"GUID-7666ACFD-1750-4A1E-BD94-CF334616F2B4\">Dynamic Properties</span> attributes. \n               		\n            </li>\n            <li>Create an nCache for the nCloth shirt. \n               		\n            </li>\n            <li>Identify problem areas in the simulation, such as poorly deformed polygons or interpenetrations.\n               \n               		\n            </li>\n            <li>Edit the nCloth shirt Quality Settings. \n               		\n            </li>\n            <li>Resolve interpenetrations. \n               		\n            </li>\n         </ul>\n         <div class=\"section\"><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7CB5\"></a> \n            <h2><a name=\"GUID-66FC5DBD-E2DD-4FC2-9B58-46D9F16BBF25\"></a>Lesson Setup\n            </h2> \n            <p><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7CB4\"></a>To ensure the lesson works as described, do these steps before beginning: \n               		\n            </p> <a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7CB3\"></a><ol type=\"1\" start=\"1\">\n               <li>If you have not already done so, download the nCloth Advanced Techniques Lesson Data\n                  from the following location: \n                  			 <a href=\"http://www.autodesk.com/maya-advancedtechniques\" target=\"_blank\">http://www.autodesk.com/maya-advancedtechniques</a>. Then, set the \n                  			 <span class=\"code\">nClothAdvancedTutorials</span> directory as your Maya project. \n                  			 \n                  <p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E21\"></a>For this lesson, you need to access Maya geometry cache files in addition to the lesson\n                     scene file. \n                     			 \n                  </p> \n               </li>\n               <li>Open the scene file named \n                  			 <span class=\"code\">Character_LowRes_4.mb</span>. \n                  			 \n                  <p><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7CAF\"></a>This file can be found in the \n                     				<span class=\"code\">nClothAdvancedTutorials</span> directory that you set as your Maya project. \n                     			 \n                  </p> \n               </li>\n               <li>Import the geometry caches which animate the character’s body and shoes. See \n                  			 <span class=\"char_link\"><a href=\"GUID-EFE22F39-CDF9-4CAD-BF42-10D3A8181EE0.htm#WS1A9193826455F5FF-4855151011E1D0EC60D-3429\">Importing geometry caches</a></span>. \n                  		  \n               </li>\n               <li>To speed up the simulation of the nCloth shirt, either create a new cache for the\n                  nCloth pants, or use the pants nCache from the previous lesson. \n                  			 \n                  <p><a name=\"WS1A9193826455F5FF-4855151011E1D0EC60D-341D\"></a> To create a new nCache, in the \n                     				<span class=\"MenuCascade\" id=\"GUID-B813AE79-61D2-49AD-B831-F8617AE45937\">Outliner</span> select \n                     				<em class=\"mild\">nCloth_Pants</em>, and select \n                     				<span class=\"MenuCascade\" id=\"GUID-A4C65713-E90D-42C8-B07D-F96EE0DF86A5\">nCache &gt; Create New Cache &gt; nObject</span>. \n                     			 \n                  </p> \n                  <p><a name=\"WS1A9193826455F5FF-4855151011E1D0EC60D-341C\"></a>To use the nCloth pants nCache from the previous lesson, you may need to reconnect\n                     the cache to the nCloth object. See \n                     				<span class=\"char_link\"><a href=\"GUID-EFE22F39-CDF9-4CAD-BF42-10D3A8181EE0.htm#WS1A9193826455F5FF-4855151011E1D0EC60D-3426\">Reconnecting objects to existing caches</a></span>. \n                     			 \n                  </p> \n               </li>\n            </ol> \n            <p><a name=\"WS73099CC142F487557230B50811D7D192C64-6D21\"></a>If you use a Maya scene file from a previous lesson, ensure that you: \n               		\n            </p> <a name=\"WS73099CC142F487557230B50811D7D192C64-6D20\"></a><ul>\n               <li>Turn off the visibility for the Reference_Character object in the Display Layer editor.\n                  \n                  		  \n               </li>\n               <li>Hide the Pants_HighRes object. \n                  		  \n               </li>\n            </ul> \n         </div>\n         <div class=\"section\"><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7CAA\"></a> \n            <h2><a name=\"GUID-44E79C68-9F07-40FA-8ABD-4E3A6B158534\"></a>Converting the shirt to nCloth\n            </h2> <a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7CA9\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7CA8\"></a>To convert the shirt to nCloth\n            </p>\n            <ol type=\"1\" start=\"1\">\n               <li>Show the Shirt_LowRes object by selecting it in the \n                  			 <span class=\"MenuCascade\" id=\"GUID-2BD284B3-FC2A-44BC-9F38-2B35FA76659B\">Outliner</span>, and then selecting \n                  			 <span class=\"MenuCascade\" id=\"GUID-C3D01B9B-6599-4A28-80B8-C2A7147C3C82\">Display &gt; Show &gt; Show Selection</span>. \n                  		  \n               </li>\n               <li>Select the low resolution shirt object (Shirt_LowRes) and select \n                  			 <span class=\"MenuCascade\" id=\"GUID-79F1F50C-C640-438A-87A1-15EABEF66E3F\">nCloth &gt; Create nCloth</span> &gt; \n                  			 <img src=\"../images/GUID-96432FB8-EBE9-4D1A-8DED-5173E032EBC0-low.png\">. \n                  		  \n               </li>\n               <li>In the \n                  			 <span class=\"MenuCascade\" id=\"GUID-2C8637C0-23A3-47B3-84DC-4AB6A0CE6D3F\">Create nCloth Options</span>window, select \n                  			 <span class=\"MenuCascade\" id=\"GUID-61256D7A-B7A4-4B40-87C3-8C3D6DCD158F\">nucleus1</span> from the \n                  			 <span class=\"MenuCascade\" id=\"GUID-86A47408-5EEB-4D68-A032-4780206AC965\">Solver</span> drop down list.\n                  		  \n               </li>\n               <li>Click \n                  			 <span class=\"MenuCascade\" id=\"GUID-F35FF9B0-CE48-4023-8CEB-09B76ED31C9A\">Create Cloth</span>. \n                  			 \n                  <p><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7CA0\"></a>The low resolution shirt is converted to an nCloth object, and is added to the existing\n                     Maya Nucleus solver. \n                     			 \n                  </p> \n               </li>\n               <li>To ensure that the low resolution nCloth shirt is easy to identify in your scene,\n                  rename it. To do this, in the \n                  			 <span class=\"MenuCascade\" id=\"GUID-221F26D9-E5B5-4E6B-AD2E-62F16F11934A\">Outliner</span>, double-click \n                  			 <em class=\"mild\">nCloth1</em>, type \n                  			 <em class=\"mild\">nCloth_Shirt</em>, then press Enter. \n                  		  \n               </li>\n               <li>Cache the nCloth shirt simulation by selecting \n                  			 <em class=\"mild\">nCloth_Shirt</em> in the<span class=\"MenuCascade\" id=\"GUID-658AEF2C-D0AC-4494-9722-051EFA7DB153\"> Outliner</span> and selecting \n                  			 <span class=\"MenuCascade\" id=\"GUID-F9648839-17BD-4017-A90D-2590469395C4\">nCache &gt; Create New Cache &gt; nObject</span>. \n                  		  \n               </li>\n               <li>Play back the simulation. \n                  		  \n               </li>\n            </ol> \n            <div class=\"section\"><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7A86\"></a> \n               <h3><a name=\"GUID-D9EBAA2A-4EA7-4537-A042-DA85FAB5F28D\"></a>Applying an nCloth preset to the shirt\n               </h3> \n               <p><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7C9C\"></a>When you play back the simulation, you notice the following: \n                  		  \n               </p> <a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7C9B\"></a><ul>\n                  <li>Around frame 1033, the shirt collar is stretching too much to resemble the fabric\n                     it\'s trying to emulate. \n                     			 \n                  </li>\n                  <li>At frame 1033, some of the shirt’s vertices are self trapped within the object, and\n                     interpenetrations between the shirt and pants appear around the character’s waist.\n                     This is caused by inaccurate collisions between the nCloth shirt and nCloth pants\n                     objects. \n                     				<a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E1F\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-700D9ABD-A6DD-48F1-A09C-51014555AAE6-low.png\"></div> \n                  </li>\n                  <li>At frame 1037, the polygon faces in the front of the shirt are deforming poorly. \n                     			 \n                  </li>\n                  <li>Between frames 1040 and 1045, some of the shirt’s vertices are trapped by the nCloth\n                     pants, and there are interpenetrations. \n                     			 \n                  </li>\n               </ul> \n               <p><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7C96\"></a>A useful way to solve a number of these simulation problems simultaneously is to apply\n                  an nCloth attribute preset to the nCloth shirt object. \n                  		  \n               </p> <a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7A85\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7A84\"></a>To apply an nCloth preset to the shirt\n               </p>\n               <ol type=\"1\" start=\"1\">\n                  <li>In the scene view, select the nCloth shirt. \n                     			 \n                  </li>\n                  <li>In the \n                     				<span class=\"MenuCascade\" id=\"GUID-8B0C438E-6744-4452-898A-E67C821AEF13\">Attribute Editor</span>, select the \n                     				<span class=\"MenuCascade\" id=\"GUID-629FA3A3-804F-44D8-AF17-A46703EEE143\">nCloth_ShirtShape</span> tab. \n                     			 \n                  </li>\n                  <li>Click-hold the \n                     				<span class=\"MenuCascade\" id=\"GUID-58E83B21-35C5-434D-980D-927568D4CDFE\">Presets \n                        				</span>button. \n                     			 \n                  </li>\n                  <li>Select the \n                     				<span class=\"MenuCascade\" id=\"GUID-D51A2CBE-F163-4D9E-B6B3-F16707C8FBAC\">tshirt \n                        				</span>preset, and then \n                     				<span class=\"MenuCascade\" id=\"GUID-E9D0DF52-77D7-4FA0-ACF5-20042FDC3169\">Replace</span> (<span class=\"MenuCascade\" id=\"GUID-207FF16C-8A51-4F6A-88BB-59F09CEDBF83\">tshirt &gt; Replace</span>). \n                     			 \n                  </li>\n               </ol> \n               <p><a name=\"WS73099CC142F48755-1EB804411AF8B41570-7395\"></a>Some important attribute adjustments made by the t-shirt preset are the following:\n                  \n                  		  \n               </p> <a name=\"WS73099CC142F48755-1EB804411AF8B41570-7394\"></a><ul>\n                  <li> <span class=\"MenuCascade\" id=\"GUID-4CE7FCEA-7475-4824-9848-B3BACF736096\">Stretch Resistance \n                        				</span>is adjusted from 20 to 35. \n                     			 \n                  </li>\n                  <li> <span class=\"MenuCascade\" id=\"GUID-F5B8153D-3896-4040-9AE6-0C73CAD8FE58\">Bend Angle Dropoff \n                        				</span>is adjusted from 0 to 0.4. \n                     				\n                     <p><a name=\"WS73099CC142F48755-1EB804411AF8B41570-7391\"></a><span class=\"MenuCascade\" id=\"GUID-C5A1A0CF-3B58-4E0F-9C71-E241C0298543\">Bend Angle Dropoff \n                           				  </span>adds resistance to bending forces by responding to the angle and strength of the force\n                        applied to the nCloth. For example, a high \n                        				  <span class=\"MenuCascade\" id=\"GUID-451A10FF-1AF3-434B-A8F3-6F9B64763F46\">Bend Angle Dropoff</span> causes an nCloth to resist bending at higher angles more than at lower angles. When\n                        you simulate the shirt, you will see \n                        				  <span class=\"MenuCascade\" id=\"GUID-D80673E4-E9E9-47F7-8EB8-F07EA92EFC93\">Bend Angle Dropoff</span> reducing the nCloth\'s tendency to bend when it is beginning to bundle up at frame\n                        1032. \n                        				\n                     </p> \n                  </li>\n                  <li> <span class=\"MenuCascade\" id=\"GUID-FF547A25-837E-4727-8F72-71B5B22BB6E9\">Mass \n                        				</span>is adjusted from 1.0 to 0.6. \n                     				\n                     <p><a name=\"WS73099CC142F48755-1EB804411AF8B41570-738F\"></a>The reduction in \n                        				  <span class=\"MenuCascade\" id=\"GUID-5E253CB5-7E6A-4F55-93DA-94E287E5C8ED\">Mass \n                           				  </span>reflects the light to medium weight material of a cotton t-shirt. \n                        				\n                     </p> \n                  </li>\n                  <li> <span class=\"MenuCascade\" id=\"GUID-AF0633AE-FF40-45C0-A9A8-0C92392D8714\">Damp \n                        				</span>is adjusted from 0.0 to 0.8. \n                     			 \n                  </li>\n               </ul> \n               <p><a name=\"WS1A9193826455F5FF-4855151011E1D0EC60D-341A\"></a>Cache the simulation by selecting the nCloth shirt and selecting \n                  			 <span class=\"MenuCascade\" id=\"GUID-8DAACC44-F041-4F8F-A47F-3D202C9D3755\">nCache &gt; Replace Cache &gt; nObject</span>and then play it back to observe the results. \n                  		  \n               </p> \n            </div> \n            <div class=\"section\"><a name=\"WS73099CC142F48755-1EB804411AF8B41570-738D\"></a> \n               <h3><a name=\"GUID-EF33B139-7382-444C-A64A-0E288A8D5792\"></a>Wrapping the high resolution mesh\n               </h3> \n               <p><a name=\"WS73099CC142F48755-1EB804411AF8B41570-738C\"></a>In this section of the lesson, you use a wrap deformer to create an influence object\n                  for the high resolution shirt. \n                  		  \n               </p> <a name=\"WS73099CC142F48755-1EB804411AF8B41570-738B\"></a><p class=\"list-intro\"><a name=\"WS73099CC142F48755-1EB804411AF8B41570-738A\"></a>To wrap the high resolution mesh\n               </p>\n               <ol type=\"1\" start=\"1\">\n                  <li>Show the Shirt_HighRes object by selecting it in the \n                     				<span class=\"MenuCascade\" id=\"GUID-622EC6CD-9657-48AE-B78B-9BBC927D0A0F\">Outliner</span>, and then selecting \n                     				<span class=\"MenuCascade\" id=\"GUID-FD23C0DD-81E0-4EE0-9C99-B96873A302D9\">Display &gt; Show &gt; Show Selection</span>. \n                     			 \n                  </li>\n                  <li>In the scene view, Shift-select the nCloth shirt object. \n                     				\n                     <p><a name=\"GUID-4BA1A3DD-4492-446C-A8D4-E3611EB5231F\"></a>Both the Shirt_LowRes and the Shirt_HighRes should now be selected. \n                        				\n                     </p> \n                  </li>\n                  <li>From the \n                     				<span class=\"MenuCascade\">Animation</span> menu set, select \n                     				<span class=\"MenuCascade\">Anim Deform &gt; Open Full Deform Menu</span>. \n                     			 \n                  </li>\n                  <li>From the \n                     				<span class=\"MenuCascade\" id=\"GUID-C43168C1-DC2A-4902-9A2A-F2D1488CDABF\">Deform</span> menu that appears, select \n                     				<span class=\"MenuCascade\" id=\"GUID-D83F4AE2-FDAC-4646-A0E1-1C86A28711B5\">Wrap</span>&gt; \n                     				<img src=\"../images/GUID-96432FB8-EBE9-4D1A-8DED-5173E032EBC0-low.png\">. \n                     			 \n                  </li>\n                  <li>In the \n                     				<span class=\"MenuCascade\" id=\"GUID-16AD7C02-CED5-4F0B-A8D1-0E6E3256C86B\">Create Wrap Options</span> window, turn on \n                     				<span class=\"MenuCascade\" id=\"GUID-7F403BB1-F670-4338-AD64-30BCF655D1EE\">Exclusive bind</span>. \n                     			 \n                  </li>\n                  <li>Click \n                     				<span class=\"MenuCascade\" id=\"GUID-8ABA63C8-1638-42E2-8370-B7D6E1C1AA38\">Create</span>. \n                     				\n                     <p><a name=\"WS1A9193826455F5FF-4855151011E1D0EC60D-3418\"></a>A wrap node appears in the \n                        				  <span class=\"MenuCascade\" id=\"GUID-2D8D2C61-59BB-4239-83B8-E1850E008104\">Attribute Editor</span>, and a Shirt_LowResBase object appears in the \n                        				  <span class=\"MenuCascade\" id=\"GUID-B082C403-2BCB-4024-8A9E-DDCAAA2B4615\">Outliner</span>. \n                        				\n                     </p> \n                  </li>\n                  <li> <span class=\"MenuCascade\" id=\"GUID-CF00DD53-640A-419B-92D2-6341F844A41A\">Hide \n                        				</span>the Shirt_HighRes object. \n                     			 \n                  </li>\n               </ol> \n            </div> \n            <div class=\"section\"><a name=\"WS73099CC142F48755-1EB804411AF8B41570-7382\"></a> \n               <h3><a name=\"GUID-A1239C88-FF20-4EF4-8B61-1DA4474667FF\"></a>Identifying problem areas in the simulated nCloth\n               </h3> \n               <p><a name=\"WS73099CC142F48755-1EB804411AF8B41570-7381\"></a>When you play back the simulation, you notice the following: \n                  		  \n               </p> <a name=\"WS73099CC142F48755-1EB804411AF8B41570-7380\"></a><ul>\n                  <li>At frame 1032, the excessive stretching around the shirt\'s collar is reduced. However,\n                     this area of the nCloth is still stretching too much. \n                     				<a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E1C\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-79504961-5175-4EAC-950C-EAB0A9B61BC5-low.png\"></div> \n                  </li>\n                  <li>At frame 1033, in the waist area, some previous instances of self trapped vertices\n                     have been resolved, however some interpenetrations still remain. \n                     			 \n                  </li>\n               </ul> \n               <p><a name=\"WS73099CC142F48755-1EB804411AF8B41570-737C\"></a>The nCloth t-shirt preset has improved many of the simulation issues, however some\n                  \n                  			 <span class=\"MenuCascade\" id=\"GUID-A3597491-58B2-46D2-BF2A-EFB8B73226C8\">Dynamic Properties \n                     			 </span>attributes need further adjustment. \n                  		  \n               </p> \n               <p><a name=\"WS73099CC142F48755-1EB804411AF8B41570-737B\"></a>When editing the \n                  			 <span class=\"MenuCascade\" id=\"GUID-1F03B4F3-A9E0-40E4-B44A-FB1DB72854BB\">Dynamic Properties \n                     			 </span>attributes, cache your simulation and then play it back between attribute adjustments\n                  to see how your new settings affect the nCloth shirt\'s behavior. For comparison purposes,\n                  you can also display the reference character in the scene. To do this, in the \n                  			 <span class=\"MenuCascade\" id=\"GUID-F45A7C4E-2ADF-4C6F-8A59-CE14F3E9D455\">Display Layer</span> editor, turn on Visible. \n                  		  \n               </p> <a name=\"WS73099CC142F48755-1EB804411AF8B41570-737A\"></a><p class=\"list-intro\"><a name=\"WS73099CC142F48755-1EB804411AF8B41570-7379\"></a>To edit the shirt\'s \n                  			 <span class=\"MenuCascade\" id=\"GUID-439A4A3B-12BA-4C7F-8260-DEDDA9E3164D\">Dynamic Properties</span></p>\n               <ol type=\"1\" start=\"1\">\n                  <li>In the \n                     				<span class=\"MenuCascade\" id=\"GUID-12076FDD-6203-4CF0-8402-B0BF9A38CA79\">Attribute Editor</span>, click the \n                     				<span class=\"MenuCascade\" id=\"GUID-EFDD4926-DBB2-4252-9A50-8FA89299EF88\">nCloth_ShirtShape</span> tab. \n                     			 \n                  </li>\n                  <li>In the \n                     				<span class=\"MenuCascade\" id=\"GUID-D49D96A5-914A-49C5-8B81-DDC2F416F36D\">Dynamic Properties</span> section, make the following settings: \n                     				<a name=\"WS73099CC142F48755-1EB804411AF8B41570-7374\"></a><ul>\n                        <li><span class=\"MenuCascade\" id=\"GUID-561A498C-CC42-47D8-A55C-86133CE54F16\">Stretch Resistance</span>: 55 \n                           				  \n                        </li>\n                        <li><span class=\"MenuCascade\" id=\"GUID-8A013F8B-B9A2-4544-AD31-7DCD150C203D\">Compression Resistance</span>: 3 \n                           				  \n                        </li>\n                        <li><span class=\"MenuCascade\" id=\"GUID-9A445C1B-8BB8-48BD-954D-9FA9472F979F\">Bend Resistance</span>: 0.3 \n                           					 <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E1A\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-C5197AD5-73F7-4002-906E-500DC10C40BF-low.png\"></div> \n                        </li>\n                     </ul> \n                  </li>\n                  <li>Cache your simulation, and play it back. \n                     			 \n                  </li>\n               </ol> \n            </div> \n            <div class=\"section\"><a name=\"WS73099CC142F48755-1EB804411AF8B41570-76D3\"></a> \n               <h3><a name=\"GUID-D583E7A6-3516-4FCE-8412-7D3A9C928FA1\"></a>Editing the \n                  			 <span class=\"MenuCascade\" id=\"GUID-DFFD167C-CC04-43D7-8227-6C185AD8F71F\">Quality Settings</span> and resolving interpenetrations\n               </h3> \n               <p><a name=\"WS73099CC142F48755-1EB804411AF8B41570-76D2\"></a>When you play back the simulation, you notice the following: \n                  		  \n               </p> <a name=\"WS73099CC142F48755-1EB804411AF8B41570-736F\"></a><ul>\n                  <li>Between frames 1028 and 1034, around the character\'s waist, there are areas where\n                     the pants and shirt no longer overlap. Also, at the character\'s back there is still\n                     some of the shirt\'s vertices trapped by the pants. \n                     				<a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E19\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-AED45B51-B628-40A1-9E96-BE3B7E892D93-low.png\"></div> \n                     <p><a name=\"WS73099CC142F48755-1EB804411AF8B41570-736D\"></a>The offset between the nCloth object occurs because the collision \n                        				  <span class=\"MenuCascade\" id=\"GUID-0CE5C235-AF7C-45F4-9EE4-FA8604CF8FDE\">Thickness</span> is currently set to accommodate the high resolution wrap deformer. Reducing \n                        				  <span class=\"MenuCascade\" id=\"GUID-90D96647-ED43-40A1-9C71-50388C93FB42\">Thickness \n                           				  </span>may solve this issue, but be aware that interpenetrations can result from such an\n                        adjustment. For the purposes of this tutorial, \n                        				  <span class=\"MenuCascade\" id=\"GUID-B5C770D3-00FD-4ECC-858C-085AFBD1DAF7\">Thickness \n                           				  </span>is left at its present value. \n                        				\n                     </p> \n                  </li>\n               </ul> \n               <p><a name=\"WS73099CC142F48755-1EB804411AF8B41570-76D1\"></a>To smooth the mesh and reduce instances of interpenetrations, edit the \n                  			 <span class=\"MenuCascade\" id=\"GUID-5C761574-74AB-4368-B3D2-73FC96FD7B31\">Quality Settings</span>. \n                  		  \n               </p> <a name=\"WS73099CC142F48755-1EB804411AF8B41570-76D0\"></a><p class=\"list-intro\"><a name=\"WS73099CC142F48755-1EB804411AF8B41570-76CF\"></a>To edit the \n                  			 <span class=\"MenuCascade\" id=\"GUID-9591C8A6-C8DC-40C3-833C-33FF4AC6B546\">Quality Settings</span></p>\n               <ol type=\"1\" start=\"1\">\n                  <li>In the \n                     				<span class=\"MenuCascade\" id=\"GUID-ECA3EAC1-9E83-40F9-9AD8-9117EA76E3AD\">Attribute Editor</span>, select the \n                     				<span class=\"MenuCascade\" id=\"GUID-F8FF80D8-6201-437A-ABDB-96BC70140E41\">nCloth_ShirtShape</span> tab. \n                     			 \n                  </li>\n                  <li>In the \n                     				<span class=\"MenuCascade\" id=\"GUID-6017CA50-5124-4EE0-B3EB-C6BB0FF1CE82\">Quality Settings</span> section, set the following: \n                     				<a name=\"WS73099CC142F48755-1EB804411AF8B41570-76CB\"></a><ul>\n                        <li><span class=\"MenuCascade\" id=\"GUID-8AEFF1B2-C05B-4CAE-8FC2-EF142050F48C\">Max Iterations</span>: 12000. \n                           				  \n                        </li>\n                        <li><span class=\"MenuCascade\" id=\"GUID-A0C874BB-EA1A-47A2-BB19-67BBC5411920\">Max Self Collision Iterations</span>: 8. \n                           				  \n                        </li>\n                        <li>Turn on \n                           					 <span class=\"MenuCascade\" id=\"GUID-D1988761-C4EA-4FC0-A580-5944AAD71A99\">Trapped Check</span>. \n                           				  \n                        </li>\n                        <li>Turn on \n                           					 <span class=\"MenuCascade\" id=\"GUID-045042FB-5119-4952-B237-E533BC3B808A\">Self Trapped Check</span>. \n                           					 <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E17\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-B771A09F-504D-4DFE-A781-7558CD041662-low.png\"></div> \n                        </li>\n                     </ul> \n                  </li>\n                  <li>Cache the simulation (<span class=\"MenuCascade\" id=\"GUID-C257B322-C21E-402C-AF99-F019A10BFE89\">nCache &gt; Replace Cache &gt; nObject</span>) and play it back. \n                     			 \n                  </li>\n               </ol> \n            </div> \n            <div class=\"section\"><a name=\"WS73099CC142F48755-1EB804411AF8B41570-736A\"></a> \n               <h3><a name=\"GUID-38618E40-5F30-465C-B94C-568753A5326F\"></a>Fine tuning the simulation\n               </h3> \n               <p><a name=\"WS73099CC142F48755-1EB804411AF8B41570-7369\"></a>To further improve the quality of the simulation and reduce the instances of interpenetration\n                  in problem areas, such as the bunching of the shirt in the chest area (see frame 1040)\n                  you can set \n                  			 <span class=\"MenuCascade\" id=\"GUID-5119A787-804B-42C7-8303-9B8E3EF13361\">Push Out</span> and \n                  			 <span class=\"MenuCascade\" id=\"GUID-FCF7C256-3D73-4CB7-AD08-807029B3C459\">Push Out Radius</span>. Try setting the attributes values between the following ranges: \n                  		  \n               </p> <a name=\"WS73099CC142F48755-1EB804411AF8B41570-7367\"></a><ul>\n                  <li> <span class=\"MenuCascade\" id=\"GUID-EFD033D3-DF32-47F4-AE27-F6B508072B35\">Push Out</span>: 0.1—20 \n                     			 \n                  </li>\n                  <li> <span class=\"MenuCascade\" id=\"GUID-257C800F-5CAB-4F13-94CF-1A0747DA3B71\">Push Out Radius</span>: 10—50 \n                     			 \n                  </li>\n               </ul> \n               <p><a name=\"WS73099CC142F48755-1EB804411AF8B41570-7364\"></a>Experiment with your settings by creating duplicates of the meshes at specific frames\n                  of the simulation. For example, create mesh duplicates at frames 1040 and 1043. Cache\n                  the simulation, and then scrub through the \n                  			 <span class=\"MenuCascade\" id=\"GUID-8DF39860-60A4-4CE0-AA80-EF602E5A60BE\">Time Slider</span> and compare your simulation with your duplicate mesh to see the results of your attribute\n                  edits. \n                  		  \n               </p> \n            </div> \n            <div class=\"section\"><a name=\"WS73099CC142F48755-1EB804411AF8B41570-76B9\"></a> \n               <h3><a name=\"GUID-60B10A78-F713-4312-968A-40023466340E\"></a>Comparing the final low resolution simulation with the simulated reference character\n                  mesh\n               </h3> \n               <p><a name=\"WS73099CC142F48755-1EB804411AF8B41570-76B8\"></a>In this lesson, you compare the final simulation result of the nCloth shirt and nCloth\n                  pants objects with the simulated reference character object (the original simulated\n                  high resolution mesh). \n                  		  \n               </p> <a name=\"WS73099CC142F48755-1EB804411AF8B41570-76B7\"></a><p class=\"list-intro\"><a name=\"WS73099CC142F48755-1EB804411AF8B41570-76B6\"></a>To compare the simulations\n               </p>\n               <ol type=\"1\" start=\"1\">\n                  <li>Hide the Shirt_LowRes and Pants_LowRes objects, selecting by selecting them in the\n                     \n                     				<span class=\"MenuCascade\" id=\"GUID-C7BEB5D6-2A91-45D1-9282-DF323581A2AE\">Outliner</span>, and then selecting \n                     				<span class=\"MenuCascade\" id=\"GUID-B2101034-5619-42F8-9C02-B386FD9D6ABC\">Display &gt; Hide &gt; Hide Selection</span>. \n                     			 \n                  </li>\n                  <li>Show the Shirt_HighRes and the Pants_HighRes objects by selecting them in the \n                     				<span class=\"MenuCascade\" id=\"GUID-F5312406-0881-4615-99A4-0C87AAA0C63A\">Outliner</span>, and then selecting \n                     				<span class=\"MenuCascade\" id=\"GUID-D18DB2EB-7DC1-4391-BFC7-F7D63EADF2E1\">Display &gt; Show &gt; Show Selection</span>. \n                     			 \n                  </li>\n                  <li>Using the \n                     				<span class=\"MenuCascade\" id=\"GUID-8DD67938-C477-4870-B5DD-B10F16C47856\">Display Layer</span> editor ( \n                     				<span class=\"MenuCascade\" id=\"GUID-66FC8CF8-C452-42A2-94D8-5D408F410621\">Channel Box/ Layer Editor&gt; Display Tab &gt; Layers &gt; Set Selected Layers \n                        				</span>), turn on Visible to display the Reference_Character object. \n                     			 \n                  </li>\n                  <li>In the \n                     				<span class=\"MenuCascade\" id=\"GUID-34296C70-06F5-4F48-970C-016E0905FDA5\">Shading</span> menu, turn off \n                     				<span class=\"MenuCascade\" id=\"GUID-90C7C8F2-57E1-4472-AD47-96E02306F0CF\">Wireframe on Shaded</span>. \n                     			 \n                  </li>\n                  <li>Scrub through the \n                     				<span class=\"MenuCascade\" id=\"GUID-49C99170-AFDD-4A16-A2FC-C2F9FF2EE1FE\">Timeline</span>, to compare how the nCloth meshes behave in the animation. Dolly and tumble the scene\n                     so that you can closely observe the problem areas. \n                     				\n                     <div><a name=\"WS1A9193826455F5FF-4855151011E1D0EC60D-3416\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span> \n                           <p><a name=\"GUID-CB8F17C8-9CE0-44E6-82FB-4800D4A98FC4\"></a>If the Reference_Character is not animated in the scene view when you play back or\n                              scrub the simulation, you may need to reconnect the reference character’s caches to\n                              their respective objects. See \n                              					 <span class=\"char_link\"><a href=\"GUID-EFE22F39-CDF9-4CAD-BF42-10D3A8181EE0.htm#WS1A9193826455F5FF-4855151011E1D0EC60D-3426\">Reconnecting objects to existing caches</a></span>. \n                              				  \n                           </p> \n                        </div>\n                     </div> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E15\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-9E935A19-55BF-405C-85C4-5D514CEEBE04-low.png\"></div> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E14\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-73A48884-C5DD-4C31-9C13-841322FEE527-low.png\"></div> \n                  </li>\n               </ol> \n               <p><a name=\"WS73099CC142F48755-1EB804411AF8B41570-76B1\"></a>There are subtle differences in the way the high resolution and reference character\n                  objects simulate, but overall the nCloth behaves in similar ways. Considering the\n                  amount of time saved by repeatedly working through the simulation workflow of caching\n                  the simulation and adjusting attributes on the low resolution mesh, this workflow\n                  provides good results. Although the reference character object can be improved by\n                  optimizing the simulation, the higher resolution mesh slows down caching and simulation\n                  time and might require more attribute adjustments. \n                  		  \n               </p> \n            </div> \n         </div>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";